# AMPH*IB*IOUS documentation

<a name="amphibious"></a>

![amphibious](assets/amphibious.png)

**AMPH*IB*IOUS** is a direct numerical simulation (DNS) solver for the incompressible Navier--Stokes equations, based on the **immersed boundary** (IB) method. The core IB algorithm is described in the paper by [Luchini et al. (2025)](http://arxiv.org/abs/2506.14328), published in the *Journal of Computational Physics* **539**, 114245, 2025.
 
The name **AMPH*IB*IOUS** emphasizes the ability to adapt to different environments. The source can be compiled for CPU or GPU; the program works on computational domains that have either a simple shape described analytically, or a complex shape described via STL files.
The distribution includes two **tutorial examples**: the flow in a plane channel (analytical geometry), and the flow in the human nose (STL geometry).

The code is written in [CPL](http://cplcode.net) and parallelized using MPI and OpenACC for CPUs and (multi)GPUs. 
OpenACC support for NVIDIA GPUs enables a wide range of graphics hardware. 
The code is very fast.

The program is split in three parts: `preproc`, `solver` and `postproc`, and is controlled via a single input file `settings.in`. 

The **first** program, `preproc`, runs in parallel on CPUs and carries out preliminary work:

- defines the computational volume, and creates a Cartesian mesh within it;
- decomposes the meshed volume into subdomains, called *cubes*, establishes connectivity among cubes, and gets rids of empty cubes;
- computes the IB coefficients;
- sets the boundary conditions;
- writes to disk all the information later needed by `solver`.

The **second** program, `solver`, runs in parallel on CPUs or GPUs, and executes the actual simulation:

- advances the solution in time;
- optionally computes flow statistics;
- optionally writes to disk a database of flow snapshots.

The **third** program, `postproc`, runs in parallel on CPUs and prepares for flow visualization and statistics:

- converts snapshots (if available) in VTK; 
- converts runtime-computed statistics (if available) in VTK;
- produces ASCII files with statistics averaged over homogeneous directions (if available).


# Documentation

Documentation is available for each component of **AMPH*IB*IOUS**:

[Overview](overview.md): a brief tour of the code, with step-by-step instructions to run the tutorials

[Preproc](preproc.md): geometry, mesh, boundary conditions

[Solver](solver.md): code layout, communication strategy, main variables

[Postproc](postproc.md): output files, flow statistics, VTK for visualization
