# AMPH*IB*IOUS: A MultiPlatform High-performance Immersed-Boundary Incompressible Open-soUrce Solver

(which thrives on CPUs or GPUs, managing simple geometries and STL files too)

Code website: [http://amphibious.cfd](http://amphibious.cfd)

<!--- ## A MultiPhase Immersed-Boundary Incompressible Open-soUrce Solver -->

<img src="documentation/docs/assets/amphibious.png" width="100">

**AMPH*IB*IOUS** is a DNS code that:

- solves the incompressible Navier-Stokes equations;
- is explicit in time, and corrects pressure iteratively;
- uses second-order finite differences; 
- implements a simple immersed-boundary method, fully second-order;
- runs fast on CPUs and GPUs;
- accepts analytical descriptions of simple geometries;
- accepts STL-based descriptions of complex geometries;
- is written in **[CPL](https://cplcode.net)**.

## Literature

- Code documentation: *[here](http://www.amphibious.cfd/documentation/)*
- Immersed-boundary method: [Luchini et al. (2025)](http://arxiv.org/abs/2506.14328)
- Pressure correction, code description and validation: paper in preparation... 

## Requirements

- the **[CPL](https://cplcode.net/Download)** compiler and its (few) dependencies (current version tested with `2025-11-02-cpl.sh`)
- a C compiler (current version tested with `gcc` v.12.2.0 and v.14.2.0) and the `nvc` compiler (current version tested with `nvc` v.23.11 and v.25.1)
- MPI for parallel CPU computing (current version tested with `openmpi` v.4.1.6 and v.5.0.7 and `hpcx-mpi` v.2.19); GPU-aware support required for multiGPU computing; 
- OpenACC >=2.6 for parallel (multi)GPU computing

## Main files

- `preproc.cpl`: sets the case up (472 lines)
- `solver.cpl`: solves the case (542 lines)
- `postproc.cpl`: post-processes the case for statistics and visualization (457 lines)
- `headers.cpl`: macro and definitions shared by `preproc` and `solver` (54 lines)
- modules (2702 lines)
- `Makefile`: compilation commands for `preproc`, `solver`, `postproc` and utilities
- `examples/channel/`: tutorial example with analytically defined geometry (flow in a plane channel)
- `examples/nose/`: tutorial example with STL-defined geometry (flow in the human nose)

## Development and testing

The folders contain all is needed to run the cases, as well as the expected screen output to be reproduced. Please reproduce `reference-output.dat` for the two examples before issuing a Merge Request

## Performance

Performance data is before code optimization.

- Scalar CPU performance: 0.055 seconds per million points/timestep
- Parallel CPU performance: nearly linear scaling observed up to 1024 cores
- Single-GPU performance: 0.00067 seconds per million points/timestep (3 pressure iterations)
- Multi-GPU performance: linear scaling observed up to 32 GPUs, where one timestep for *one billion* points takes less than 0.02 seconds

<img src="documentation/docs/assets/scaling.jpg" width="600">

## Contributors

marco.atzori@polimi.it, niccolo.berizzi@polimi.it, francesco.esposito@polimi.it, paolo.luchini@cplcode.net, andrea.portioli@polimi.it, maurizio.quadrio@polimi.it and others
